--
-- PoettingerJumbo10000
-- Specialization for PoettingerJumbo10000 functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		30/09/10
--

PoettingerJumbo10000 = {};

function PoettingerJumbo10000.prerequisitesPresent(specializations)
	return true;
end;

function PoettingerJumbo10000:load(xmlFile)

	self.hayBase = {};
	self.hayBase.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hayBase#index"));
	self.hayBase.unloadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#unloadingSpeed"), 0.002);
	self.hayBase.loadingSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.hayBase#loadingSpeed"), 0.0005);
	self.hayBase.speed = self.hayBase.loadingSpeed;
	self.hayBase.unloadingDirection = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hayBase#unloadingDirection"), 1);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	
	self.doTractorFixPointSearch = true;
end;

function PoettingerJumbo10000:delete()
end;

function PoettingerJumbo10000:readStream(streamId, connection)
end;

function PoettingerJumbo10000:writeStream(streamId, connection)
end;

function PoettingerJumbo10000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PoettingerJumbo10000:keyEvent(unicode, sym, modifier, isDown)
end;

function PoettingerJumbo10000:update(dt)
end;


function PoettingerJumbo10000:updateTick(dt)	
end;

function PoettingerJumbo10000:draw()	
end;

function PoettingerJumbo10000:onAttach(attacherVehicle)
	self.doJointSearch = true;
end;

function PoettingerJumbo10000:onDetach()
end;

function PoettingerJumbo10000:onDeactivate()
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;

function PoettingerJumbo10000:onStartTip(currentTipTrigger, noEventSend)
	self:setIsTurnedOn(true);
	setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.unloadingSpeed,0,0,0,false);
end;

function PoettingerJumbo10000:onEndTip(noEventSend)
	self:setIsTurnedOn(false);
	setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
end;

function PoettingerJumbo10000:setIsTurnedOn(turnedOn, noEventSend)
	if turnedOn then			
		setShaderParameter(self.hayBase.node, "movingDirection", self.hayBase.unloadingDirection*self.hayBase.loadingSpeed,0,0,0,false);
	else
		setShaderParameter(self.hayBase.node, "movingDirection", 0,0,0,0,false);
	end;
end;