--MP-Events for specialization workMode 1.0

-- Cylinder state
WorkModeCylinderEvent = {};
WorkModeCylinderEvent_mt = Class(WorkModeCylinderEvent, Event);

InitEventClass(WorkModeCylinderEvent, "WorkModeCylinderEvent");

function WorkModeCylinderEvent:emptyNew()
    local self = Event:new(WorkModeCylinderEvent_mt);
    self.className="WorkModeCylinderEvent";
    return self;
end;

function WorkModeCylinderEvent:new(object, isCylinderActive, cylinderSetManual)
    local self = WorkModeCylinderEvent:emptyNew()
    self.object = object;
	self.isCylinderActive = isCylinderActive;
	self.cylinderSetManual = cylinderSetManual;
    return self;
end;

function WorkModeCylinderEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.isCylinderActive = streamReadBool(streamId);
	self.cylinderSetManual = streamReadBool(streamId);
	self:run(connection);
    
end;

function WorkModeCylinderEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCylinderActive);
	streamWriteBool(streamId, self.cylinderSetManual);
end;

function WorkModeCylinderEvent.sendEvent(object, isCylinderActive, cylinderSetManual, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(WorkModeCylinderEvent:new(object, isCylinderActive, cylinderSetManual), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(WorkModeCylinderEvent:new(object, isCylinderActive, cylinderSetManual));
		end;
	end;
end;

function WorkModeCylinderEvent:run(connection)
    self.object:setIsCylinderActive(self.isCylinderActive, self.cylinderSetManual, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WorkModeCylinderEvent:new(self.object, self.isCylinderActive, self.cylinderSetManual), nil, connection, self.object);
    end;
end;

-- Cutter state
WorkModeCutterEvent = {};
WorkModeCutterEvent_mt = Class(WorkModeCutterEvent, Event);

InitEventClass(WorkModeCutterEvent, "WorkModeCutterEvent");

function WorkModeCutterEvent:emptyNew()
    local self = Event:new(WorkModeCutterEvent_mt);
    self.className="WorkModeCutterEvent";
    return self;
end;

function WorkModeCutterEvent:new(object, isCutterActive, cutterSetManual)
    local self = WorkModeCutterEvent:emptyNew()
    self.object = object;
	self.isCutterActive = isCutterActive;
	self.cutterSetManual = cutterSetManual;
    return self;
end;

function WorkModeCutterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	self.isCutterActive = streamReadBool(streamId);
	self.cutterSetManual = streamReadBool(streamId);
   	self:run(connection);

end;

function WorkModeCutterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.isCutterActive);
	streamWriteBool(streamId, self.cutterSetManual);
end;

function WorkModeCutterEvent:run(connection)
    self.object:setIsCutterActive(self.isCutterActive, self.cutterSetManual, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(WorkModeCutterEvent:new(self.object, self.isCutterActive, self.cutterSetManual), nil, connection, self.object);
    end;
end;