--
-- extendedExhaustPS (EEPS)
-- special-function of Ahwi FM700 V2
--
-- author: Patar (Thomas Heck)
-- date: 02.02.15
--

extendedExhaustPS = {};

function extendedExhaustPS.prerequisitesPresent(specializations)
    return true;
end;

function extendedExhaustPS:load(xmlFile)
	self.EEPS = {}
	self.EEPS.backupExhaustColor = {min={}, max={}};
	self.EEPS.startDuration = getXMLInt(xmlFile, "vehicle.stumpCutterStartSound#extendedExhaustPSstart")
	self.EEPS.endDuration = getXMLInt(xmlFile, "vehicle.stumpCutterStartSound#extendedExhaustPSend")
	self.EEPS.maxIntensity = getXMLInt(xmlFile, "vehicle.stumpCutterStartSound#maxIntensity")
	self.EEPS.duration = 0;
	self.EEPS.lastTurnedOn = false;
	self.EEPS.intensity = 0;
end;

function extendedExhaustPS:delete()
end;

function extendedExhaustPS:mouseEvent(posX, posY, isDown, isUp, button)
end;

function extendedExhaustPS:keyEvent(unicode, sym, modifier, isDown)
end;

function extendedExhaustPS:update(dt)
end;

function extendedExhaustPS:updateTick(dt)
	if self:getIsTurnedOn() then
		if not self.EEPS.lastTurnedOn then
			self.EEPS.duration = 0;
			self.EEPS.intensity = self.EEPS.backupExhaustColor.min[4];
		end;
		self.EEPS.duration = self.EEPS.duration + dt;
		if (self.EEPS.duration >= self.EEPS.startDuration and self.EEPS.duration <= self.EEPS.endDuration) then
			if self.EEPS.intensity < self.EEPS.maxIntensity then
				self.EEPS.intensity = self.EEPS.intensity + math.min(0.5, self.EEPS.maxIntensity-self.EEPS.intensity);
			end;
			self.attacherVehicle.exhaustEffects[1].minRpmColor[1] = 0;
			self.attacherVehicle.exhaustEffects[1].minRpmColor[2] = 0;
			self.attacherVehicle.exhaustEffects[1].minRpmColor[3] = 0;
			self.attacherVehicle.exhaustEffects[1].minRpmColor[4] = self.EEPS.intensity;
			self.attacherVehicle.exhaustEffects[1].maxRpmColor[1] = 0;
			self.attacherVehicle.exhaustEffects[1].maxRpmColor[2] = 0;
			self.attacherVehicle.exhaustEffects[1].maxRpmColor[3] = 0;
			self.attacherVehicle.exhaustEffects[1].maxRpmColor[4] = self.EEPS.intensity;
		else
			if self.EEPS.intensity > self.EEPS.backupExhaustColor.min[4] then
				self.EEPS.intensity = self.EEPS.intensity - math.min(0.5, self.EEPS.intensity-self.EEPS.backupExhaustColor.min[4]);
				self.attacherVehicle.exhaustEffects[1].minRpmColor[1] = 0;
				self.attacherVehicle.exhaustEffects[1].minRpmColor[2] = 0;
				self.attacherVehicle.exhaustEffects[1].minRpmColor[3] = 0;
				self.attacherVehicle.exhaustEffects[1].minRpmColor[4] = self.EEPS.intensity;
				self.attacherVehicle.exhaustEffects[1].maxRpmColor[1] = 0;
				self.attacherVehicle.exhaustEffects[1].maxRpmColor[2] = 0;
				self.attacherVehicle.exhaustEffects[1].maxRpmColor[3] = 0;
				self.attacherVehicle.exhaustEffects[1].maxRpmColor[4] = self.EEPS.intensity;
			else
				for i = 1,4 do
					self.attacherVehicle.exhaustEffects[1].minRpmColor[i] = self.EEPS.backupExhaustColor.min[i];
					self.attacherVehicle.exhaustEffects[1].maxRpmColor[i] = self.EEPS.backupExhaustColor.max[i];
				end;
			end;
		end;
	else
		if self.EEPS.lastTurnedOn then
			for i = 1,4 do
				self.EEPS.lastAttacherVehicle.exhaustEffects[1].minRpmColor[i] = self.EEPS.backupExhaustColor.min[i];
				self.EEPS.lastAttacherVehicle.exhaustEffects[1].maxRpmColor[i] = self.EEPS.backupExhaustColor.max[i];
			end;
		end;
	end;
	self.EEPS.lastTurnedOn = self:getIsTurnedOn();
end;

function extendedExhaustPS:draw()
end;

function extendedExhaustPS:onAttach()
	for i = 1,4 do
		if self.attacherVehicle.exhaustEffects == nil then
			break;
		end;
		self.EEPS.backupExhaustColor.min[i] = self.attacherVehicle.exhaustEffects[1].minRpmColor[i];
		self.EEPS.backupExhaustColor.max[i] = self.attacherVehicle.exhaustEffects[1].maxRpmColor[i];
	end;
	self.EEPS.lastAttacherVehicle = self.attacherVehicle;
end;

function extendedExhaustPS:onActivate()
end;


