--
-- moveCutNode
-- Specialization for moving the cutNode to give a new dimension to the cutNode
--
-- author: Patar
-- date: 28.01.15
--

moveCutNode = {};

function moveCutNode.prerequisitesPresent(specializations)
    return true;
end;

function moveCutNode:load(xmlFile)
	self.moveMinX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#moveMinX"), -1);
	self.moveMaxX = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpCutter#moveMaxX"), 1);
	self.moveStep = 0.15;
end;

function moveCutNode:delete()
end;

function moveCutNode:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveCutNode:keyEvent(unicode, sym, modifier, isDown)
end;

function moveCutNode:update(dt)
	if self:getIsTurnedOn() then
		if self.stumpCutterParticleSystems.isEmitting == false then
			local x,y,z = getTranslation(self.stumpCutterCutNode);
			if x > self.moveMaxX or x < self.moveMinX then
				self.moveStep = -self.moveStep;
			end;
			x = x + self.moveStep;
			setTranslation(self.stumpCutterCutNode, x, y, z);
		end;
	end;
end;

function moveCutNode:updateTick(dt)
end;

function moveCutNode:draw()
end;

function moveCutNode:onEnter()
end;