--
-- ahwiFM700
-- special functions for Ahwi FM700 V2.
--
-- author: Patar
-- date: 03.01.15
--

ahwiFM700 = {};

function ahwiFM700.prerequisitesPresent(specializations)
    return true;
end;

function ahwiFM700:load(xmlFile)

-- StumpColliMovement (SCM)
	self.SCM = {};
	self.SCM.valueY = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueY"), 1);
	self.SCM.valueZ = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.stumpColli#valueZ"), -1);
	self.SCM.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stumpColli#index"))
	self.maxCutTime = 6000;
-- StumpColliMovement (SCM)

-- DustParticles (DP)
	self.DP = {PS={}, free=false, isPloughing=false};
	Utils.loadParticleSystem(xmlFile, self.DP.PS, "vehicle.stumpCutter.dustParticleSystem", self.components, false, nil, self.baseDirectory)
-- DustParticles (DP)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	self.workAreas[1].disableBackwards = false;
	self.PE = {PS={}, maxResetTime=1000, resetTime=0, isActive=false};
	Utils.loadParticleSystem(xmlFile, self.PE.PS, "vehicle.ploughParticleSystem", self.components, false, nil, self.baseDirectory);
	self.PE.PS.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ploughParticleSystem#node"))
	self.PE.refNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.ploughParticleSystem#refNode"))
	self.PE.rotOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.ploughParticleSystem#rotOffset"), 0);
	self.PE.flapWarning = {
							overlay = Overlay:new("flapWarning", Utils.getFilename("shared/smallUpDown.dds", self.baseDirectory), 0.475, 0.8, 0.1, 0.1*g_screenAspectRatio),
							active = true,
							timer = 0,
							timerMax = 700,
							};
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	self.MCL = {};
	self.MCL.backupBig = {
							rotMax = self.movingTools[2].rotMax;
							rotMin = self.movingTools[2].rotMin;
							};
	self.MCL.backupSmall = {
							rotMax = self.movingTools[1].rotMax;
							rotMin = self.movingTools[1].rotMin;
							};
-- MouseControlLimit (MCL)

end;

function ahwiFM700:delete()
	Utils.deleteParticleSystem(self.DP.PS);
	--Utils.deleteParticleSystem(self.PE.PS);
end;

function ahwiFM700:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ahwiFM700:keyEvent(unicode, sym, modifier, isDown)
end;

function ahwiFM700:update(dt)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	if self.lastPloughArea > 0 then
		self.PE.resetTime = 0;
	end;
	self.PE.resetTime = self.PE.resetTime + dt;
	self.PE.isActive = self.PE.resetTime < self.PE.maxResetTime;
-- PloughingExtension (PE) ]]--

end;

function ahwiFM700:updateTick(dt)

-- StumpColliMovement (SCM)
	if not self.stumpCutterParticleSystems.isEmitting then
		setTranslation(self.SCM.index, 0, self.SCM.valueY, 0);
	else
		local actZ = (1-self.nextCutTime/self.maxCutTime)*self.SCM.valueZ;
		setTranslation(self.SCM.index, 0, 0, actZ);
	end;
-- StumpColliMovement (SCM)

-- DirtParticles (DP)
	if self.stumpCutterParticleSystems.isEmitting then
		self.DP.free = true;
	end;
	Utils.setEmittingState(self.DP.PS, (self.resetCutTime > 0 and self.DP.free and self:getIsTurnedOn()) or (self.hasWheelGroundContact and self:getIsTurnedOn()));
-- DirtParticles (DP)

--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	Utils.setEmittingState(self.PE.PS, self.ploughHasGroundContact and self:getIsTurnedOn() and self.PE.isActive);
	local x, y, z = getRotation(self.PE.refNode);
	setRotation(self.PE.PS.node, math.max(x-math.rad(self.PE.rotOffset), 0), y, z);
	if self.PE.flapWarning.timer > self.PE.flapWarning.timerMax then
		self.PE.flapWarning.active = not self.PE.flapWarning.active;
		self.PE.flapWarning.timer = 0;
	end;
	self.PE.flapWarning.timer = self.PE.flapWarning.timer + dt;
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	if self.movingTools[2].curRot[1] > 0.619 then
		self.movingTools[1].rotMin = self.movingTools[1].rotMax-0.005;
	else
		self.movingTools[1].rotMin = self.MCL.backupSmall.rotMin;
	end;
	if self.movingTools[1].curRot[1] < self.MCL.backupSmall.rotMax-0.01 then
		self.movingTools[2].rotMax = 0.619;
	else
		self.movingTools[2].rotMax = self.MCL.backupBig.rotMax;
	end;
-- MouseControlLimit (MCL)

end;

function ahwiFM700:draw()
--[[ PloughingExtension (PE)  -- NO PLOUGHING FOR FM700H!
	local x, y, z = getRotation(self.PE.PS.node);
	if self.ploughHasGroundContact and self:getIsTurnedOn() and self.PE.isActive and x == 0 and self.PE.flapWarning.active then
		self.PE.flapWarning.overlay:render();
	end;
-- PloughingExtension (PE) ]]--

-- MouseControlLimit (MCL)
	if (InputBinding.getInputAxis(InputBinding.AXIS_FRONTLOADER_ARM) < 0 or InputBinding.getIsInputMouseAxisTriggered(InputBinding.AXIS_FRONTLOADER_ARM)) and self.movingTools[2].curRot[1] == 0.619 then
		setTextColor(1,0.1,0.1,1); setTextBold(true); setTextAlignment(RenderText.ALIGN_CENTER);
		renderText(0.5, 0.92, 0.03, g_i18n:getText("MCL_pleaseLower"))
		setTextColor(1,1,1,1); setTextBold(false); setTextAlignment(RenderText.ALIGN_RIGHT);
	end;
-- MouseControlLimit (MCL)
end;

function ahwiFM700:onEnter()
end;