--
-- ahwiFM700H
-- special functions for Ahwi FM700H.
--
-- author: Patar
-- date: 15.03.15
--

ahwiFM700H = {};

function ahwiFM700H.prerequisitesPresent(specializations)
    return true;
end;

function ahwiFM700H:load(xmlFile)
	self.lastNextCutTime = 0;
end;

function ahwiFM700H:delete()
end;

function ahwiFM700H:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ahwiFM700H:keyEvent(unicode, sym, modifier, isDown)
end;

function ahwiFM700H:update(dt)
end;

function ahwiFM700H:updateTick(dt)
	if self.nextCutTime < self.lastNextCutTime then
		if math.abs(self.lastNextCutTime-self.nextCutTime) < 1000 then
			self:setFillLevel(math.abs(self.lastNextCutTime-self.nextCutTime)/18, Fillable.FILLTYPE_WOODCHIPS);
		end;
	end;
	self.lastNextCutTime = self.nextCutTime;
	
	if self.currentPipeState == 1 then
		self.movingTools[5].isActive = true;
	else
		self.movingTools[5].isActive = false;
	end;
	local rotLimit = self.movingTools[5].curRot[1];
	if rotLimit ~= self.pipeNodes[2].states[1].rotation[1] then
		self.pipeNodes[2].states[1].rotation[1] = rotLimit;
		self.pipeNodes[2].curRotation[1] = rotLimit;
		setRotation(self.pipeNodes[2].node, rotLimit, 0, 0);
	end;
end;

function ahwiFM700H:draw()
end;

function ahwiFM700H:onEnter()
end;