--
-- dynamicPowerConsumer
-- Specialization to distinguish the consumed Power between working and idle
--
-- author: Patar
-- date: 30.01.15
--

dynamicPowerConsumer = {};

function dynamicPowerConsumer.prerequisitesPresent(specializations)
    return true;
end;

function dynamicPowerConsumer:load(xmlFile)
	self.powerConsumer.neededPtoPowerAtIdle = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.powerConsumer#neededPtoPowerAtIdle"), 0.5*self.powerConsumer.neededPtoPower);
	self.powerConsumer.neededPtoPowerAtWork = self.powerConsumer.neededPtoPower;
end;

function dynamicPowerConsumer:delete()
end;

function dynamicPowerConsumer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dynamicPowerConsumer:keyEvent(unicode, sym, modifier, isDown)
end;

function dynamicPowerConsumer:update(dt)
end;

function dynamicPowerConsumer:updateTick(dt)
	if self:getIsTurnedOn() then
		if self.stumpCutterParticleSystems.isEmitting == true then
			self.powerConsumer.neededPtoPower = self.powerConsumer.neededPtoPowerAtWork;
		else
			self.powerConsumer.neededPtoPower = self.powerConsumer.neededPtoPowerAtIdle;
		end;
	end;
end;

function dynamicPowerConsumer:draw()
end;

function dynamicPowerConsumer:onDetach()
	self.powerConsumer.needPtoPower = self.powerConsumer.neededPtoPowerAtWork;
end;