--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--
-- free for noncommerical-usage
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		self.isOpen = self.vehicle.currentLight == 3;
	end;
	InteractiveComponentInterface.update(self, dt);
end;
function Button:draw()
	InteractiveComponentInterface.draw(self);
end;
function Button:doAction(dt)
	if self.event == "FARI" then
		if self.vehicle ~= nil then
			if self.vehicle.realLightsActive then
				self.vehicle:setLightsVisibility(false);
			else
				self.vehicle:setLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "FARILAVOROANT" then
		if self.vehicle ~= nil then
			local i = 1;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.event == "FARILAVOROPOST" then
		if self.vehicle ~= nil then
			local i = 2;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
		if self.event == "FARILAVOROANT2" then
		if self.vehicle ~= nil then
			local i = 3;
			if self.vehicle.B3.work[i].a then
				self.vehicle:setState("work:"..i, false);
			else
				self.vehicle:setState("work:"..i, true);
			end;
		end;
	end;
	if self.vehicle ~= nil then
		local targetTurnSignalState = nil
		if self.event == "toggleRightIndicator"  then
			targetTurnSignalState = Vehicle.TURNSIGNAL_RIGHT;
		end;
		if self.event == "toggleLeftIndicator" then
			targetTurnSignalState = Vehicle.TURNSIGNAL_LEFT;
		end;
		if self.event == "toggleWarningLights" then
			targetTurnSignalState = Vehicle.TURNSIGNAL_HAZARD;
		end;
		if targetTurnSignalState ~= nil then
			if targetTurnSignalState == self.vehicle.turnSignalState then
				self.vehicle:setTurnSignalState( Vehicle.TURNSIGNAL_OFF );
			else
				self.vehicle:setTurnSignalState( targetTurnSignalState );
			end;
		end;
	end;
	if self.event == "BEACONLIGHTS" then
		if self.vehicle ~= nil then
			if self.vehicle.beaconLightsActive then
				self.vehicle:setBeaconLightsVisibility(false);
			else
				self.vehicle:setBeaconLightsVisibility(true);
			end;
		end;
	end;
	if self.event == "lowerBack" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
	end;
	if self.event == "lowerBack2" then
		if self.vehicle.lowerBack then
			self.vehicle:setJointMoveDown(1, false);
			self.vehicle.lowerBack = false;
		else
			self.vehicle:setJointMoveDown(1, true);
			self.vehicle.lowerBack = true
		end;
	end;
	if self.event == "lowerFront" then
		if self.vehicle.lowerFront then
			self.vehicle:setJointMoveDown(2, false);
			self.vehicle.lowerFront = false;
		else
			self.vehicle:setJointMoveDown(2, true);
			self.vehicle.lowerFront = true;
		end;
	end;
	if self.event == "ptoToggle" then
		if self.vehicle ~= nil then
			for k, implement in pairs(self.vehicle.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn ~= nil then
						if implement.object.isTurnedOn then
							implement.object.isTurnedOn = false;
						else
							implement.object.isTurnedOn = true;
						end;
					end;
				end;
			end;
		end;
	end;
	if self.event == "togglePipe" then
		if forceAction == nil then
			local nextState = self.vehicle.targetPipeState+1;
			if nextState > self.vehicle.numPipeStates then
				nextState = 1;
			end;
			self.vehicle:setPipeState(nextState, true);
		end;
	end;
	if self.event == "toggleChopper" then
		local newValue = not self.vehicle.isStrawEnabled;
		if forceAction ~= nil then
				newValue = not forceAction;
		end;
		if self.vehicle.lastValidInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
			local fruitDesc = FruitUtil.fruitIndexToDesc[self.vehicle.lastValidInputFruitType];
			if fruitDesc.hasWindrow then
				--self.vehicle.isStrawEnabled = not self.vehicle.isStrawEnabled;
				self.vehicle:setIsStrawEnabled(newValue);
			end;
		else
			--self.vehicle.isStrawEnabled = not self.vehicle.isStrawEnabled;
			self.vehicle:setIsStrawEnabled(newValue);
		end;
	end;
	if self.event == "toggleOnOff" then
		if self.vehicle:getIsTurnedOnAllowed(not self.vehicle.isTurnedOn)  then
			self.vehicle:setIsTurnedOn(not self.vehicle.isTurnedOn);
		end;
	end;
	if self.event == "toggleFolding" then
		if self.vehicle ~= nil then
			for k, implement in pairs(self.vehicle.attachedImplements) do
				if implement.object ~= nil then
					if implement.object:getIsFoldAllowed() then
						if implement.object:getToggledFoldDirection() == implement.object.turnOnFoldDirection then
							implement.object:setFoldState(implement.object:getToggledFoldDirection(), true);
						else
							implement.object:setFoldState(implement.object:getToggledFoldDirection(), false);
						end;
					end;
				end;
			end;
		end;
	end;
	if string.sub( self.event, 1, 10 ) == "l2gsToggle" and type( self.vehicle[self.event] ) == "function" then
		local fct = self.vehicle[self.event]
		fct( self.vehicle )
	end
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;