HP_Display = {};

function HP_Display:prerequisitesPresent(specializations)
	return true;
end;

function HP_Display:load(xmlFile)
	self.setHudValue = HP_Display.setHudValue;

    self.indoorHud = {};
	self.indoorHud.fillLevel = HP_Display.loadValue(self, xmlFile, "fillLevel");
end;

function HP_Display:loadValue(xmlFile, name)
    local numbers = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indoorHud." .. name .. "#numbers"));

    if numbers ~= nil then
        local precision = nil;
        local numChilds = nil;
        local maxValue = nil;
        if numbers ~= nil then
            precision = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.indoorHud." .. name .. "#precision"), 1);
            numChilds = getNumOfChildren(numbers);
            if numChilds-precision <= 0 then
                print("Warning: Not enough number meshes in '".. tostring(self.object.xmlFilename) .."'");
            end;
            numChilds = numChilds - precision;
            maxValue = (10 ^ (numChilds)) - 1/(10^precision); -- e.g. max with 2 childs and 1 float -> 10^2 - 1/10 -> 99.9 -> makes sure that display doesn't show 00.0 if value is 100
        end;

        local hud = {numbers = numbers, lastNormValue = 0, lastValue = -1, precision = precision, maxValue = maxValue, numChilds = numChilds};

        self:setHudValue(hud, 0, 0);

        return hud;
    end;

    return nil;
end;

function HP_Display:delete()
end;

function HP_Display:update(dt)
end;

function HP_Display:updateTick(dt)
	if self:getIsActive() then
		if self.indoorHud.fillLevel ~= nil then
			local fillLevel, capacity = 0, 0;
			
			-- option 1 - attached tools only --
			-- local implements = self.vehicle.attachedImplements;
			-- for k, v in ipairs (implements) do
				-- local Tfill, Tcap = v.object:getAttachedTrailersFillLevelAndCapacity(); -- get sub trailer of sub trailer...
				
				-- if Tfill ~= nil then
					-- fillLevel = fillLevel + Tfill;
					-- capacity = capacity + Tcap;
				-- end;
			-- end;
			
			-- option 2 - get fillLevel on tractor too --
			local Tfill, Tcap = self.vehicle:getAttachedTrailersFillLevelAndCapacity();
			if Tfill ~= nil then
				fillLevel = Tfill;
				capacity = Tcap;
			end;
			
			self:setHudValue(self.indoorHud.fillLevel, fillLevel, capacity);
		end;
	end;
end;

function HP_Display:draw()
end;

function HP_Display:setHudValue(hud, value, maxValue)
    if hud.numbers ~= nil then
        if math.abs(hud.lastValue-value) > 1/(10^(hud.precision+1)) then
            local displayedValue = math.min(hud.maxValue, math.max(0, value));
            local speed = tonumber(string.format("%."..hud.precision.."f", displayedValue));
            Utils.setNumberShaderByValue(hud.numbers, speed, hud.precision, true);
            hud.lastValue = value;
        end;
    end;
end;