RepairVehiclesEvent = {};
RepairVehiclesEvent_mt = Class(RepairVehiclesEvent, Event);
InitEventClass(RepairVehiclesEvent, "RepairVehiclesEvent");
function RepairVehiclesEvent:emptyNew()
    local self = Event:new(RepairVehiclesEvent_mt);
    self.className="RepairVehiclesEvent";
    return self;
end;

function RepairVehiclesEvent:new(object)
    local self = RepairVehiclesEvent:emptyNew(); 
    self.object = object; 
    return self;
end;

function RepairVehiclesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
end;

function RepairVehiclesEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self:run(connection);
end;

function RepairVehiclesEvent:run(connection)
	if g_server ~= nil then
		self.object:repairVehicles(true);
	end;
end;

function RepairVehiclesEvent.sendEvent(object)
	g_client:getServerConnection():sendEvent(RepairVehiclesEvent:new(object)); 
end;