----------------------------------------------------------------------------------------------------------------------
-- @date: 				Initial Release [FS13] Unknown
-- @history: 			Unknown
-- @Initialauthor:		Unknown / Its written since FS13 / we convert the script and fix most of the code

-- @version: 			1.4b 	-- 	Dedi Server Code fixes / EditDate 17.08.2016 Edit by Marc-Modding & Blacky_BPG
-- @version: 			1.4 	-- 	Written a query of EngineLoad / Edit by Marc-Modding & Blacky_BPG
-- @version: 			1.3a 	-- 	Convert to FS17 / EditDate 27.05.2017 Edit by Marc-Modding & Blacky_BPG
-- @version: 			1.1 	-- 	Convert to FS15 / EditDate 20.02.2016 Edit by Marc-Modding & Blacky_BPG
----------------------------------------------------------------------------------------------------------------------
--
--MODDESC Entries:
--<specialization name="LuefterSound" 			className="LuefterSound" 			filename="XXX/LuefterSound.lua"/>
--<vehicleTypes> 
--
--
--<type name="XXX" className="" filename="$dataS/scripts/vehicles/Vehicle.lua"> 
--<specialization name="LuefterSound"/> 
--</type> 
--</vehicleTypes>
--
--
--XML Entries:	
--<fanSound file="" pitchOffset="" volume="" radius="" innerRadius="" indoorVolumeFactor="" indoorLowpassGain=""/>
--
----------------------------------------------------------------------------------------------------------------------


LuefterSound = {}
LuefterSound.modDir = g_currentModDirectory

function LuefterSound.prerequisitesPresent(specializations) return true end

function LuefterSound:load(savegame)
      local fanSound = getXMLString(self.xmlFile, "vehicle.fanSound#file")
        if fanSound ~= nil and fanSound ~= "" then
            fanSound = Utils.getFilename(fanSound, self.baseDirectory)
			self.fanSound = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.fanSound", nil, LuefterSound.modDir, self.components[1].node)
            self.fanSoundVolume = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.fanSound#volume"), 0.5) --Lautstaerke des Soundfiles wenn nicht in XML definiert
            self.fanSoundTime = 102200 --Laenge des FanSoundFiles in ms
            self.startTime = 1
            self.startTimeDiff = 4000 --Dauer bis das Soundfile agespielt wird
            self.stopTime = 0
            self.fanSoundEnabled = false
      end
end

function LuefterSound:delete()         
     if self.fanSound ~= nil then
		SoundUtil.deleteSample(self.fanSound)
    end  
end

function LuefterSound:update(dt)     
    if self.isMotorStarted then 
       if self:getIsActiveForSound() and g_currentMission.controlledVehicle == self then
            if self.fanSound ~= nil then
                if self.fanSoundEnabled then
					self.stopTime = self.stopTime - dt
					if self.stopTime <= 0 then
						SoundUtil.stopSample(self.fanSound, true)
						self.fanSoundEnabled = false
					end
                end
                if not self.fanSoundEnabled and self.startTime < 1 then
					SoundUtil.playSample(self.fanSound,0,0,self.fanSoundVolume)
                    self.stopTime = self.fanSoundTime
                    self.fanSoundEnabled = true
                end
            end
        end
    else
-- Nachlauffunktion des Lfters
-- wenn der Motor aus ist und der Lfter luft dann wird dieser nach der normalen Zeit erst abgeschaltet
         if self:getIsActiveForSound() and g_currentMission.controlledVehicle == self then
            if self.fanSound ~= nil then
                if self.fanSoundEnabled then
					self.stopTime = self.stopTime - dt
					if self.stopTime <= 0 then
						SoundUtil.stopSample(self.fanSound, true)
						self.fanSoundEnabled = false
					end
				end
			end
		end
    end
end

function LuefterSound:updateTick(dt)
	if self.isMotorStarted then
		if self.fanSound ~= nil then
--[[
Abfrage Motorlast
	- wir fragen die Motorlast ab, wollen aber das er zumindest ein wenig Last bekommt auch wenn er steht und nichts tut
		deshalb die math.max Funktion mit nem Mindestwert von 0.25
	
	- im Anschlu multiplizieren wir die Motorlast nochmal mit sich selbst bevor wir sie zur Zeit addieren
		auch hier wieder mit nem Mindestwert von 0.25 (hier: mLoad) weil 0.25 * 0.25 sind 0.0625, da ist der Anstieg zu gering
		- bei 0,5 Motorlast wren das dann 0.25 zum hochzhlen, bei 1,2 Motorlast sind wir damit schon bei 1.44 und
			wie bei dem Drescher hier im Normalfall bei Maximallast von 1,52 wird dann bereits 2.31 addiert
		- so ist der addierte Anstieg steiler als die tatschliche Motorlast und im Leerlauf bzw bei niedriger Last
			springt der Lfter wenigstens nicht andauernd an
		- man kann das Ganze auch noch weiter treiben, mit der auskommentierten Zeile, da hat er als Mindestwert
			natrlich auch wieder die 0.25 aber die anderen Werte variieren natrlich noch weitaus mehr durch die 3fache Multiplikation
			- 	0,5  Motorlast = 0.125 Addition (trifft nicht zu da 0.25 Mindestwert, erst ab 0,63 Motorlast gehts los)
				1,2  Motorlast = 1.728 Addition
				1,52 Motorlast = 3.512 Addition
--]]
			local mLoad = math.max(self.motor:getMotorLoad(),0.25)
			self.startTime = self.startTime + math.max((mLoad*mLoad),mLoad)
			-- self.startTime = self.startTime + math.max((mLoad*mLoad*mLoad),mLoad)
			if self.startTime > self.startTimeDiff then
				self.startTime = 0
			end
		end
	end
end

function LuefterSound:stopSounds()
    if self.isClient then
         if self.fanSoundEnabled then
              SoundUtil.stopSample(self.fanSound, true)
              self.fanSoundEnabled = false
         end
    end
end
function LuefterSound:onEnter()
    if self.isClient then
         if self.fanSoundEnabled then
              SoundUtil.playSample(self.fanSound,0,0,self.fanSoundVolume)
         end
    end
end
function LuefterSound:onLeave()
    if self.isClient then
         if self.fanSoundEnabled then
              SoundUtil.stopSample(self.fanSound, true)
         end
    end
end

function LuefterSound:startMotor() end
function LuefterSound:stopMotor() end
function LuefterSound:mouseEvent(posX, posY, isDown, isUp, button) end
function LuefterSound:keyEvent(unicode, sym, modifier, isDown) end
function LuefterSound:draw() end
