-- By LsPrO/TheCoCe ---> http://newmoddingteam.jimdo.com/ or http://www.modhoster.com/community/user/lspro--2
-- Please bare with me. This is my first Lua Script and it might not be optimized very well. Using lots of objects will probably cause lags.
-- Thanks to Bluebaby210 for shortening!

-- Lua for delayed rotation of objects after starting the motor.
-- Rotation speed adapts to the speed of the engine.
-- If DELAY and MULTIPLIER are not give, they will be set to 1!
-- The ROTATION AXIS is set to x by default!
-- You should not go lower than 0.01 (0.01 works best for me, but try it out for yourself) and higher than 10 for the MULTIPLIER!
-- MOTORCOOLDOWN: If you enter in time, the objects won't wait for the timer and start spinning immediately!
-- MOTORCOOLDOWN: Objects will spin after leaving until the timer has run out.
-- isSpinningAfter: The default value is "true". You can change it to false for the object not to spin after exiting the vehicle.
		--> If you set DELAY to "0" while isSpinningAfter="false" you can use this e.g. as a engine shaft. <--

-- Vehicle XML e.g.:
-- <DelayedRotation motorCooldown="10">
--      <rotPart index="0>0|28" rotPartMultiplier="6" rotPartDelay="3" rotAxis="0 1 0" isSpinningAfter="false" />
--      <rotPart index="0>0|28" rotPartDelay="0" isSpinningAfter="false" />    ---> You will get a Warning if you forget one of the parameters!
--      ...
-- </DelayedRotation>

-- ModDesc:
-- <specialization name="DelayedRotation" className="DelayedRotation" filename="!!!YOURPATH!!!/DelayedRotation.lua"/>
-- <specialization name="DelayedRotation" />

DelayedRotation = {};

function DelayedRotation.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function DelayedRotation:load(savegame)

   self.rotateParts = SpecializationUtil.callSpecializationsFunction("rotateParts");
   self.rotatePartsAfter = SpecializationUtil.callSpecializationsFunction("rotatePartsAfter");


	self.delayvariable = 0;
	self.aussteigvariable = 0;
	--self.aussteigstatus = false;
	self.motorCooldown = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.DelayedRotation#motorCooldown"), 10);

   self.rotPartIndex = {};
   self.rotPartMultiplier = {};
   self.rotPartDelay = {};
   self.rotRollout = {};
   self.isSpinningAfter = {};

   self.rotPartAxiX = {};
   self.rotPartAxiY = {};
   self.rotPartAxiZ = {};

   local k = 0;
   while true do
	  local rotPartName = string.format("vehicle.DelayedRotation.rotPart(%d)",k);
	  if not hasXMLProperty(self.xmlFile, rotPartName) then
		 break;
	  end;

	  local node = getXMLString(self.xmlFile, rotPartName.. "#index");
	  if node == nil then
		 break;
	  end;

	  k = k + 1;

	  self.rotPartIndex[k] = Utils.indexToObject(self.components, node);
	  self.rotPartMultiplier[k] = Utils.getNoNil(getXMLFloat(self.xmlFile, rotPartName .. "#rotPartMultiplier"));
	  if self.rotPartMultiplier[k] == nil then
		 print("DelayedRotation: Multiplier in '"..self.configFileName.."' is nil! Multiplier set to 1!")
		 self.rotPartMultiplier[k] = 1;
	  end;
	  self.rotPartDelay[k] = Utils.getNoNil(getXMLFloat(self.xmlFile, rotPartName .. "#rotPartDelay"));
	  if self.rotPartDelay[k] == nil then
		 print("DelayedRotation: Delay in '"..self.configFileName.."' is nil! Delay set to 1!")
		 self.rotPartDelay[k] = 1;
	  end;
	  local x, y, z = Utils.getVectorFromString(getXMLString(self.xmlFile,  rotPartName .. "#rotAxis"));
	  if x == nil or x > 1 or y == nil or y > 1 or z == nil or z > 1 then
		 print("DelayedRotation: Rotation in '"..self.configFileName.."' is nil! Rotation set to X: 1, Y: 0, Z:0!")
		 x = 1;
		 y = 0;
		 z = 0;
	  end;

	  self.rotPartAxiX[k] = x;
	  self.rotPartAxiY[k] = y;
	  self.rotPartAxiZ[k] = z;

	  self.rotRollout[k] = 0;
	  self.isSpinningAfter[k] = Utils.getNoNil(getXMLBool(self.xmlFile, rotPartName .. "#isSpinningAfter"), true);
   end;
end;

function DelayedRotation:delete()
end;

function DelayedRotation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DelayedRotation:keyEvent(unicode, sym, modifier, isDown)
end;

function DelayedRotation:update(dt)
   if self:getIsActive() then
	  if self.isMotorStarted then
		 self.delayvariable = self.delayvariable + 1;
		 self:rotateParts(dt);
	  end;
   end;

   --if self.aussteigstatus then
   if not self.isMotorStarted then
	--  if self.aussteigvariable < (self.motorCooldown*60) + 100 then
	--     self.aussteigvariable = self.aussteigvariable + 1;
	--  end;
	  self:rotatePartsAfter(dt);
   end;
end;

function DelayedRotation:updateTick(dt)
end;

function DelayedRotation:draw()
end;

function DelayedRotation:onEnter()
   --self.aussteigstatus = false;
   --if self.aussteigvariable > self.motorCooldown*60 then
	  self.delayvariable = 0;
   --end;
   --self.aussteigvariable = 0;

end;

function DelayedRotation:onLeave()
   --self.aussteigstatus = true;
end;

function DelayedRotation:rotatePartsAfter(dt)

   for i=1, #self.rotPartIndex do
	  if self.isSpinningAfter[i] then -- self.delayvariable > (self.rotPartDelay[i]*60) and self.aussteigvariable ~= (self.motorCooldown*60) + 100
		 local motorRotateScale = 0;
		 --if self.rotRollout[i] > 0 then -- and self.aussteigvariable > (((self.motorCooldown*60) + 100)/100) * 60
			self.rotRollout[i] = math.max(0, self.rotRollout[i] - 0.005);
		 --end;
		 motorRotateScale = ((750/10000)*dt * self.rotPartMultiplier[i]) * self.rotRollout[i];

		 rotate(self.rotPartIndex[i], self.rotPartAxiX[i]*motorRotateScale,self.rotPartAxiY[i]*motorRotateScale,self.rotPartAxiZ[i]*motorRotateScale);
	  end;
   end;
end;

function DelayedRotation:rotateParts(dt)

   for i=1, #self.rotPartIndex do
	  if self.delayvariable > (self.rotPartDelay[i]*60) then
	  local motorRotateScale = 0;
		 if self.isSpinningAfter[i] then
			self.rotRollout[i] = math.min(self.rotRollout[i] + 0.005, 1);
			motorRotateScale = ((self.motor.lastMotorRpm/10000)*dt * self.rotPartMultiplier[i]) * self.rotRollout[i];
		else
			motorRotateScale = ((self.motor.lastMotorRpm/10000)*dt * self.rotPartMultiplier[i]);
		end;
		rotate(self.rotPartIndex[i], self.rotPartAxiX[i]*motorRotateScale, self.rotPartAxiY[i]*motorRotateScale,self.rotPartAxiZ[i]*motorRotateScale);
	  end;
   end;

end;