-- T7Series.lua
-- Script for New Holland T7 Series V1.0.0.0 powered by STv-Modding
--
-- Author Rival renamed: Thomas0815
-- 05.01.2016
-- Version 1.1 @26.10.2016
	--> converted to FS17
-- Version 1.2 @05.11.2016
	--> added indoorsound change when door/windows are open
-- Version 1.3 @28.12.2016 edit DerFreddy7
	--> added Xerion Lenkrad sound
	--> added Xerion Cebis terminal Sound
-- Version 1.4 @08.01.2017 edit Thomas0815
	--> changes for Deutz7
-- Verions 1.5 16.05.2017 edit by STv-Modding
    --> added new extra sounds for IC Buttons(STv-Modding)
T7Series = {};

function T7Series.prerequisitesPresent(specializations)
    return true;
end;

function T7Series:load(savegame)
    self.blinkerLight0 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T7SeriesDisplay.blinkerLight#index0"));
    self.blinkerLight1 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T7SeriesDisplay.blinkerLight#index1"));
    self.blinkerLight2 = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T7SeriesDisplay.blinkerLight#index2"));
    self.warnBlinkLight = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T7SeriesDisplay.warnBlinkLight#index"));
    setVisibility(self.blinkerLight0, false);
    setVisibility(self.blinkerLight1, false);
    setVisibility(self.blinkerLight2, false);
    self.hasAttachedTrailers = 0;
	
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
	
	if self.isClient then
		self.sampleOpenDoorleftDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/door.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorleftDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/door_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenDoorrightDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/door.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorrightDoor = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/door_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenbackWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/Fenster.wav", self.baseDirectory, self.components[1].node);
		self.sampleClosebackWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Fenster.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpentopWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/Fenster.wav", self.baseDirectory, self.components[1].node);
		self.sampleClosetopWindow = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Fenster.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpencabLight = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tl_1.wav", self.baseDirectory, self.components[1].node);
		self.sampleClosecabLight = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tl_1.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenFH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseFH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenbonnet = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/openHod.wav", self.baseDirectory, self.components[1].node);
		self.sampleClosebonnet = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Fenster.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenconsole = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseconsole = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenWarning_signal = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseWarning_signal = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenBH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseBH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenFPH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseFPH = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/Hydraulik.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenconsole_width = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseconsole_width = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/tl_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenVaderstadStation = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/terminal_on.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseVaderstadStation = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/terminal_off.wav", self.baseDirectory, self.components[1].node);
	end;
end;

--function Deutz7:postLoad(savegame)
--	for k,v in pairs(self.sampleMotor) do print(k,v) end
--end;

function T7Series:delete()
	if self.sampleOpenDoorleftDoor ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorleftDoor);
	end;
	if self.sampleOpenDoorrightDoor ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorrightDoor);
	end;
	if self.sampleOpenbackWindow ~= nil then
		SoundUtil.deleteSample(self.sampleOpenbackWindow);
	end;
	if self.sampleOpentopWindow ~= nil then
		SoundUtil.deleteSample(self.sampleOpentopWindow);
	end;
	if self.sampleCloseDoorleftDoor ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorleftDoor);
	end;
	if self.sampleCloseDoorrightDoor ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorrightDoor);
	end;
	if self.sampleClosebackWindow ~= nil then
		SoundUtil.deleteSample(self.sampleClosebackWindow);
	end;
	if self.sampleClosetopWindow ~= nil then
		SoundUtil.deleteSample(self.sampleClosetopWindow);
	end;
	if self.sampleOpencabLight ~= nil then
		SoundUtil.deleteSample(self.sampleOpencabLight);
	end;
	if self.sampleOpenFH ~= nil then
		SoundUtil.deleteSample(self.sampleOpenFH);
	end;
	if self.sampleOpenbonnet ~= nil then
		SoundUtil.deleteSample(self.sampleOpenbonnet);
	end;
	if self.sampleOpenconsole ~= nil then
		SoundUtil.deleteSample(self.sampleOpenconsole);
	end;
	if self.sampleOpenWarning_signal ~= nil then
		SoundUtil.deleteSample(self.sampleOpenWarning_signal);
	end;
	if self.sampleOpenBH ~= nil then
		SoundUtil.deleteSample(self.sampleOpenBH);
	end;
	if self.sampleOpenFPH ~= nil then
		SoundUtil.deleteSample(self.sampleOpenFPH);
	end;
	if self.sampleOpenconsole_width ~= nil then
		SoundUtil.deleteSample(self.sampleOpenconsole_width);
	end;
	if self.sampleOpenVaderstadStation ~= nil then
		SoundUtil.deleteSample(self.sampleOpenVaderstadStation);
	end;
	if self.sampleClosecabLight ~= nil then
		SoundUtil.deleteSample(self.sampleClosecabLight);
	end;
	if self.sampleCloseFH ~= nil then
		SoundUtil.deleteSample(self.sampleCloseFH);
	end;
	if self.sampleClosebonnet ~= nil then
		SoundUtil.deleteSample(self.sampleClosebonnet);
	end;
	if self.sampleCloseconsole ~= nil then
		SoundUtil.deleteSample(self.sampleCloseconsole);
	end;
	if self.sampleCloseWarning_signal ~= nil then
		SoundUtil.deleteSample(self.sampleCloseWarning_signal);
	end;
	if self.sampleCloseBH ~= nil then
		SoundUtil.deleteSample(self.sampleCloseBH);
	end;
	if self.sampleCloseFPH ~= nil then
		SoundUtil.deleteSample(self.sampleCloseFPH);
	end;
	if self.sampleCloseconsole_width ~= nil then
		SoundUtil.deleteSample(self.sampleCloseconsole_width);
	end;
	if self.sampleCloseVaderstadStation ~= nil then
		SoundUtil.deleteSample(self.sampleCloseVaderstadStation);
	end;
	
end;

function T7Series:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T7Series:keyEvent(unicode, sym, modifier, isDown)
end;

function T7Series:update(dt)
    if self:getIsActive() and self.isClient then
        if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
            self.hasAttachedTrailers = 0;
            for i=1, table.getn(self.attachedImplements) do  
                if self.attachedImplements[i].object.hasTurnLights and self.attachedImplements[i].object.hasTurnLights then 
                    self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                end;
                if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
                    for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
                        if self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights and self.attachedImplements[i].object.attachedImplements[r].object.hasTurnLights then
                            self.hasAttachedTrailers = self.hasAttachedTrailers + 1;
                        end;
                    end;
                end;
            end;
        end;
        if self.hasAttachedTrailers == 0 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, false);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 1 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, false);
        elseif self.hasAttachedTrailers == 2 then
            setVisibility(self.blinkerLight0, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight1, self.turnLightState ~= Lights.TURNLIGHT_OFF);
            setVisibility(self.blinkerLight2, self.turnLightState ~= Lights.TURNLIGHT_OFF);
        end;
        if self.turnLightState == Lights.TURNLIGHT_HAZARD then
            setVisibility(self.warnBlinkLight, true);
        else
            setVisibility(self.warnBlinkLight, false);
        end;
		if self.isEntered then
			if self:getIsAnimationPlaying("leftDoor") and self:getIsActiveForSound() then
				if self.animations["leftDoor"].currentSpeed > 0 and self.animations["leftDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorleftDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorleftDoor,1,1,nil);
					end;
				elseif self.animations["leftDoor"].currentSpeed < 0 and self.animations["leftDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorleftDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorleftDoor,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("rightDoor") and self:getIsActiveForSound() then
				if self.animations["rightDoor"].currentSpeed > 0 and self.animations["rightDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorrightDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorrightDoor,1,1,nil);
					end;
				elseif self.animations["rightDoor"].currentSpeed < 0 and self.animations["rightDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorrightDoor, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorrightDoor,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("backWindow") and self:getIsActiveForSound() then
				if self.animations["backWindow"].currentSpeed > 0 and self.animations["backWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenbackWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenbackWindow,1,1,nil);
					end;
				elseif self.animations["backWindow"].currentSpeed < 0 and self.animations["backWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleClosebackWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleClosebackWindow,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("topWindow") and self:getIsActiveForSound() then
				if self.animations["topWindow"].currentSpeed > 0 and self.animations["topWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpentopWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpentopWindow,1,1,nil);
					end;
				elseif self.animations["topWindow"].currentSpeed < 0 and self.animations["topWindow"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleClosetopWindow, 1.5*dt) then
						SoundUtil.playSample(self.sampleClosetopWindow,1,1,nil);
					end;
				end;
			 end;
			 if self:getIsAnimationPlaying("cabLight") and self:getIsActiveForSound() then
				if self.animations["cabLight"].currentSpeed > 0 and self.animations["cabLight"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpencabLight, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpencabLight,1,1,nil);
					end;
				elseif self.animations["cabLight"].currentSpeed < 0 and self.animations["cabLight"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleClosecabLight, 1.5*dt) then
						SoundUtil.playSample(self.sampleClosecabLight,1,1,nil);
					end;
				end;
			 end;
		     if self:getIsAnimationPlaying("FH") and self:getIsActiveForSound() then
				if self.animations["FH"].currentSpeed > 0 and self.animations["FH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenFH, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenFH,1,1,nil);
					end;
				elseif self.animations["FH"].currentSpeed < 0 and self.animations["FH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseFH, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseFH,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("bonnet") and self:getIsActiveForSound() then
				if self.animations["bonnet"].currentSpeed > 0 and self.animations["bonnet"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenbonnet, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenbonnet,1,1,nil);
					end;
				elseif self.animations["bonnet"].currentSpeed < 0 and self.animations["bonnet"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleClosebonnet, 1.5*dt) then
						SoundUtil.playSample(self.sampleClosebonnet,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("console") and self:getIsActiveForSound() then
				if self.animations["console"].currentSpeed > 0 and self.animations["console"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenconsole, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenconsole,1,1,nil);
					end;
				elseif self.animations["console"].currentSpeed < 0 and self.animations["console"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseconsole, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseconsole,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("Warning_signal") and self:getIsActiveForSound() then
				if self.animations["Warning_signal"].currentSpeed > 0 and self.animations["Warning_signal"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenWarning_signal, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenWarning_signal,1,1,nil);
					end;
				elseif self.animations["Warning_signal"].currentSpeed < 0 and self.animations["Warning_signal"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseWarning_signal, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseWarning_signal,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("BH") and self:getIsActiveForSound() then
				if self.animations["BH"].currentSpeed > 0 and self.animations["BH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenBH, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenBH,1,1,nil);
					end;
				elseif self.animations["BH"].currentSpeed < 0 and self.animations["BH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseBH, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseBH,1,1,nil);
					end;
				end;
		      end;
			  if self:getIsAnimationPlaying("FPH") and self:getIsActiveForSound() then
				if self.animations["FPH"].currentSpeed > 0 and self.animations["FPH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenFPH, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenFPH,1,1,nil);
					end;
				elseif self.animations["FPH"].currentSpeed < 0 and self.animations["FPH"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseFPH, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseFPH,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("console_width") and self:getIsActiveForSound() then
				if self.animations["console_width"].currentSpeed > 0 and self.animations["console_width"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenconsole_width, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenconsole_width,1,1,nil);
					end;
				elseif self.animations["console_width"].currentSpeed < 0 and self.animations["console_width"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseconsole_width, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseconsole_width,1,1,nil);
					end;
				end;
			  end;
			  if self:getIsAnimationPlaying("VaderstadStation") and self:getIsActiveForSound() then
				if self.animations["VaderstadStation"].currentSpeed > 0 and self.animations["VaderstadStation"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenVaderstadStation, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenVaderstadStation,1,1,nil);
					end;
				elseif self.animations["VaderstadStation"].currentSpeed < 0 and self.animations["VaderstadStation"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseVaderstadStation, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseVaderstadStation,1,1,nil);
					end;
				end;
			end;
			
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
					self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = 0.55;
						self.sampleMotor.indoorLowpassGain = 0.2;
						self.sampleMotorStart.indoorVolumeFactor = 0.55;
						self.sampleMotorStart.indoorLowpassGain = 0.2;
						self.sampleMotorStop.indoorVolumeFactor = 0.55;
						self.sampleMotorStop.indoorLowpassGain = 0.2;
						
						self.sampleMotorRun.indoorVolumeFactor = 0.7;
						self.sampleMotorRun.indoorLowpassGain = 0.4;
						self.sampleMotorLoad.indoorVolumeFactor = 0.7;
						self.sampleMotorLoad.indoorLowpassGain = 0.4;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function T7Series:updateTick(dt)
end;
function T7Series:draw()    
end;