-- indoorSounds.lua
-- Script for Fendt Farmer 310/312 LSA
--
-- Author Rival
-- 05.01.2016
-- Version 1.1 @26.10.2016
	--> converted to FS17
-- Version 1.2 @05.11.2016
	--> added indoorsound change when door/windows are open
-- Version 1.3 @30.11.2016 DH Modding
	--> indoorsound adapted

indoorSounds = {};

function indoorSounds.prerequisitesPresent(specializations)
    return true;
end;

function indoorSounds:load(savegame)   	
	self.soundAdj = {};
	local i=0;
    while true do
        local key = string.format("vehicle.indoorsoundAdjustment.animation(%d)", i);
        if not hasXMLProperty(self.xmlFile, key) then
            break;
        end;
        local animName = getXMLString(self.xmlFile, key.."#name");
        local lowpassGain = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#lowpassGain"), 0.5);
        local volumeFactor = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#volumeFactor"), 0.5);
		self.soundAdj[i] = {};
		self.soundAdj[i].animName = animName;
		self.soundAdj[i].volumeFactor = volumeFactor;
		self.soundAdj[i].lowpassGain = lowpassGain;
        i = i +1;
    end;
	
	if self.isClient then
		self.sampleOpenDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/door.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorL = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/door_2.wav", self.baseDirectory, self.components[1].node);
		self.sampleOpenDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.openDoorSound", "sounds/door.wav", self.baseDirectory, self.components[1].node);
		self.sampleCloseDoorR = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.closeDoorSound", "sounds/door_2.wav", self.baseDirectory, self.components[1].node);			
	end;
	
	self.OrigindoorVolumeFactor = self.sampleMotor.indoorVolumeFactor;
	self.OrigindoorLowpassGain = self.sampleMotor.indoorLowpassGain;
	self.OrigindoorVolumeFactor = self.sampleMotorStart.indoorVolumeFactor;
	self.OrigindoorLowpassGain = self.sampleMotorStart.indoorLowpassGain;
	self.OrigindoorVolumeFactor = self.sampleMotorStop.indoorVolumeFactor;
	self.OrigindoorLowpassGain = self.sampleMotorStop.indoorLowpassGain;
	
	self.OrigindoorVolumeFactor = self.sampleMotorRun.indoorVolumeFactor;
	self.OrigindoorLowpassGain = self.sampleMotorRun.indoorLowpassGain;
	self.OrigindoorVolumeFactor = self.sampleMotorLoad.indoorVolumeFactor;
	self.OrigindoorLowpassGain = self.sampleMotorLoad.indoorLowpassGain;
end;
function indoorSounds:delete()
	if self.sampleOpenDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorL);
	end;
	if self.sampleOpenDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleOpenDoorR);
	end;
	if self.sampleCloseDoorL ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorL);
	end;
	if self.sampleCloseDoorR ~= nil then
		SoundUtil.deleteSample(self.sampleCloseDoorR);
	end;
end;
function indoorSounds:mouseEvent(posX, posY, isDown, isUp, button)
end;
function indoorSounds:keyEvent(unicode, sym, modifier, isDown)
end;
function indoorSounds:update(dt)
    if self:getIsActive() and self.isClient then        
		if self.isEntered then
			if self:getIsAnimationPlaying("leftDoor") and self:getIsActiveForSound() then
				if self.animations["leftDoor"].currentSpeed > 0 and self.animations["leftDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorL,1,1,nil);
					end;
				elseif self.animations["leftDoor"].currentSpeed < 0 and self.animations["leftDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorL, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorL,1,1,nil);
					end;
				end;
			end;
			if self:getIsAnimationPlaying("rightDoor") and self:getIsActiveForSound() then
				if self.animations["rightDoor"].currentSpeed > 0 and self.animations["rightDoor"].currentTime < 50 then
					if not SoundUtil.isSamplePlaying(self.sampleOpenDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleOpenDoorR,1,1,nil);
					end;
				elseif self.animations["rightDoor"].currentSpeed < 0 and self.animations["rightDoor"].currentTime < 100 then
					if not SoundUtil.isSamplePlaying(self.sampleCloseDoorR, 1.5*dt) then
						SoundUtil.playSample(self.sampleCloseDoorR,1,1,nil);
					end;
				end;
			end;
			local sound=false;
			for i=0, #self.soundAdj do
				if self.animations[self.soundAdj[i].animName] ~= nil and self.animations[self.soundAdj[i].animName].currentTime > 500 then
					self.sampleMotor.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotor.indoorVolumeFactor);
					self.sampleMotor.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotor.indoorLowpassGain);
					self.sampleMotorStart.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStart.indoorVolumeFactor);
					self.sampleMotorStart.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStart.indoorLowpassGain);
					self.sampleMotorStop.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorStop.indoorVolumeFactor);
					self.sampleMotorStop.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorStop.indoorLowpassGain);
					
					self.sampleMotorRun.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorRun.indoorVolumeFactor);
					self.sampleMotorRun.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorRun.indoorLowpassGain);
					self.sampleMotorLoad.indoorVolumeFactor = math.max(self.soundAdj[i].volumeFactor, self.sampleMotorLoad.indoorVolumeFactor);
					self.sampleMotorLoad.indoorLowpassGain = math.max(self.soundAdj[i].lowpassGain, self.sampleMotorLoad.indoorLowpassGain);
					sound=true;
				else
					if not sound then
						self.sampleMotor.indoorVolumeFactor = self.OrigindoorVolumeFactor;
						self.sampleMotor.indoorLowpassGain = self.OrigindoorLowpassGain;
						self.sampleMotorStart.indoorVolumeFactor = self.OrigindoorVolumeFactor;
						self.sampleMotorStart.indoorLowpassGain = self.OrigindoorLowpassGain;
						self.sampleMotorStop.indoorVolumeFactor = self.OrigindoorVolumeFactor;
						self.sampleMotorStop.indoorLowpassGain = self.OrigindoorLowpassGain;
						
						self.sampleMotorRun.indoorVolumeFactor = self.OrigindoorVolumeFactor;
						self.sampleMotorRun.indoorLowpassGain = self.OrigindoorLowpassGain;
						self.sampleMotorLoad.indoorVolumeFactor = self.OrigindoorVolumeFactor;
						self.sampleMotorLoad.indoorLowpassGain = self.OrigindoorLowpassGain;
					end;
				end;
			end;
			SoundUtil.onCameraSwitched(self.activeCamera.isInside);
		end;
    end;
end;
function indoorSounds:updateTick(dt)
end;
function indoorSounds:draw()    
end;