-- motorSound.lua
-- motor sound under load
--
-- Author RivalBomb
-- 30/08/2015

motorSound = {};

function motorSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function motorSound:load(savegame)
	if self.isClient then
		self.sampleMotorRunLast = SoundUtil.loadSample(self.xmlFile, {}, "vehicle.motorSoundRunLast", nil, self.baseDirectory, self.components[1].node);
		self.motorSoundRunLastPitchScale = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.motorSoundRunLast#pitchScale"), 0.05);
		self.motorSoundRunLastPitchMax = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.motorSoundRunLast#pitchMax"), 2.0);
		
		self.motorSoundRunVolumeMax = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.motorSoundRun#volume"), 1);
		self.motorSoundVolumeMax = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.motorSound#volume"), 1);
	end;
	self.motorRunLastVolS = 0;
end;
function motorSound:delete()
	if self.sampleMotorRunLast ~= nil then
		SoundUtil.deleteSample(self.sampleMotorRunLast);
	end;
end;
function motorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function motorSound:keyEvent(unicode, sym, modifier, isDown)
end;
function motorSound:update(dt)
	if self.isMotorStarted then
        if self.isClient then
			if self:getIsActiveForSound() and not SoundUtil.isSamplePlaying(self.sampleMotorStart, 1.5*dt) then
				SoundUtil.playSample(self.sampleMotorRunLast, 0, 0, nil);
			end;
			local minRpm = self.motor.minRpm;
			local maxRpm = self.motor.maxRpm;
            local maxSpeed;
            if self.movingDirection >= 0 then
                maxSpeed = self.motor.maxForwardSpeed*0.001;
            else
                maxSpeed = self.motor.maxBackwardSpeed*0.001;
			end;
			local targetRpmOffset = (self.motor.lastMotorRpm-minRpm)*0.8 + math.min(self.lastSpeed/maxSpeed, 1)*(maxRpm-minRpm)*0.2;
			local alpha = math.pow(0.01, dt*0.001);
			local roundPerMinute = targetRpmOffset + alpha*(self.lastRoundPerMinute-targetRpmOffset);
			local roundPerSecond = roundPerMinute / 60;
			local motorSoundRunPitch = math.min(self.xmlFile.sampleMotorRunLast.pitchOffset + self.motorSoundRunLastPitchScale*math.abs(roundPerSecond), self.motorSoundRunLastPitchMax);
			SoundUtil.setSamplePitch(self.sampleMotorRunLast, motorSoundRunPitch);

			--local rpmRunVolume = math.abs(roundPerMinute)/(maxRpm - minRpm);
			local accInput = 0;
			if self.axisForward ~= nil then
				accInput = -self.axisForward;
			end;
			if self.cruiseControl ~= nil and self.cruiseControl.state ~= Drivable.CRUISECONTROL_STATE_OFF then
				accInput = 1;
			end;
			--if accInput>0 then
			--	rpmRunVolume = rpmRunVolume * math.min(math.abs(accInput)*2,1);
			--else
			--	rpmRunVolume = 0;
			--end;
			--local rpmRunVolume,_ = self.motor:getTorque(1, false)*1000;
			--local rpmRunVolume = self.motor.motorLoad;
			if self.motorRunLastVolS < self.motor.motorLoad then
				self.motorRunLastVolS = self.motorRunLastVolS+(dt/2000);
			elseif self.motorRunLastVolS > self.motor.motorLoad then
				self.motorRunLastVolS = self.motorRunLastVolS-(dt/2000);
			end;
			local rpmRunVolume = Utils.clamp(self.motorRunLastVolS, 0.0, 1.0);
			SoundUtil.setSampleVolume(self.sampleMotorRunLast, rpmRunVolume*self.sampleMotorRunLast.volume);
			
			
			local newRpmRunVolume = math.abs(roundPerMinute)/(maxRpm - minRpm);
			local normalRunVolume = (rpmRunVolume*-1)+1;
			--local normalRunVolume = 1;
			--if accInput >= 0 then
			--	normalRunVolume = (math.abs(accInput)*-1)+1;
			--else
			--	normalRunVolume = 1;
			--end;
			local finalRpmRunVolume = Utils.clamp(newRpmRunVolume*normalRunVolume, 0.0, 1.0);
			SoundUtil.setSampleVolume(self.sampleMotorRun, finalRpmRunVolume*self.motorSoundRunVolumeMax);
			
			local newIdleVolume =  math.abs(roundPerMinute)/(maxRpm - minRpm);
			newIdleVolume = (newIdleVolume*-1)+1;
			SoundUtil.setSampleVolume(self.sampleMotor, newIdleVolume*self.motorSoundVolumeMax);
		end;
	else
		if self.isClient then
			SoundUtil.stopSample(self.sampleMotorRunLast);
		end;
	end;
end;
function motorSound:updateTick(dt)
end;
function motorSound:draw()	
end;