----------------------------------------------------------------------------------------------------------------------
-- @date: 		Initial Release Unknown
-- @history: 	Unknown
-- @author:		Unknown
-- @version: 	1.1 	-- 	Convert to FS15 / EditDate 20.02.2016 Edit by Marc-Modding & Blacky_BPG
-- @version: 	1.3a 	-- 	Convert to FS17 / EditDate 27.05.2017 Edit by Marc-Modding & Blacky_BPG
--
----------------------------------------------------------------------------------------------------------------------
--
--MODDESC Entries:
--<specialization name="LuefterSound" 			className="LuefterSound" 			filename="XXX/LuefterSound.lua"/>
--<vehicleTypes> 
--<type name="XXX" className="" filename="$dataS/scripts/vehicles/Vehicle.lua"> 
--<specialization name="LuefterSound"/> 
--</type> 
--</vehicleTypes>
--
--
--XML Entries:	
--<fanSound file="" pitchOffset="" volume="" radius="" innerRadius=""/>
--
----------------------------------------------------------------------------------------------------------------------


LuefterSound = {};

function LuefterSound.prerequisitesPresent(specializations) return true end

function LuefterSound:load(xmlFile)
      local fanSound = getXMLString(self.xmlFile, "vehicle.fanSound#file");
        if fanSound ~= nil and fanSound ~= "" then
            fanSound = Utils.getFilename(fanSound, self.baseDirectory);
            self.fanSound = createSample("fanSound");
            loadSample(self.fanSound, fanSound, false);
            self.fanSoundPitchOffset = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.fanSound#pitchOffset"), 1); --PitchOffset des Souzndfiles wenn nicht in XML definiert
            self.fanSoundVolume = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.fanSound#volume"), 0.5); --Lautstaerke des Soundfiles wenn nicht in XML definiert
            setSamplePitch(self.fanSound, self.fanSoundPitchOffset);
            self.fanSoundTime = 30; --Laenge des FanSoundFiles
            self.time = 0;
            self.timeDiff = 100; --Dauer bis das Soundfile agespielt wird
            self.fanSoundEnabled = false;
      end;
end;

function LuefterSound:delete()         
     if self.fanSound ~= nil then
        stopSample(self.fanSound);
        delete(self.fanSound);
    end;  
end;

function LuefterSound:update(dt)     
    if self.isMotorStarted then 
         if self:getIsActiveForSound() then 
            if self.fanSound ~= nil then
                if not self.fanSoundEnabled and self.fanSoundTime <= self.time then
                    playSample(self.fanSound, 1, self.fanSoundVolume, 1);
                    self.fanSoundTime = self.time + self.timeDiff;
                    self.fanSoundEnabled = true;
					--print("Luefter ist an")
                end;
                if self.fanSoundEnabled and (self.fanSoundTime - (self.timeDiff/2)) <= self.time then
                    stopSample(self.fanSound)
                    self.fanSoundEnabled = false;
					--print("Luefter ist aus")
                end;
            end;
        end;
    end;
end;

function LuefterSound:updateTick(dt)
		if self.fanSound ~= nil then
        self.time = self.time + 1
        if self.time > self.timeDiff * 60 then
            self.time = 0
            self.fanSoundTime = self.timeDiff
        end;
	end;
end;

function LuefterSound:stopSounds()
    if self.isClient then
         if self.fanSoundEnabled then
              stopSample(self.fanSound);
              self.fanSoundEnabled = false;
         end;
    end;
end;

function LuefterSound:startMotor()
    self.fanSoundTime = self.time + self.timeDiff;
end;

function LuefterSound:stopMotor()
  LuefterSound.stopSounds(self);
end;

function LuefterSound:onLeave()
    LuefterSound.stopSounds(self);            
end;

function LuefterSound:mouseEvent(posX, posY, isDown, isUp, button)
end;
function LuefterSound:keyEvent(unicode, sym, modifier, isDown)
end;
function LuefterSound:draw()
end;
function LuefterSound:onEnter() 
end;