SetDoorLeftRotationEvent = {};
SetDoorLeftRotationEvent_mt = Class(SetDoorLeftRotationEvent, Event);
  
InitEventClass(SetDoorLeftRotationEvent, "SetDoorLeftRotationEvent");
  
function SetDoorLeftRotationEvent:emptyNew()
      local self = Event:new(SetDoorLeftRotationEvent_mt);
      self.className="SetDoorLeftRotationEvent";
      return self;
 end;

function SetDoorLeftRotationEvent:new(object, rotationMaxPortaEsq)
      local self = SetDoorLeftRotationEvent:emptyNew()
      self.object = object;
      self.rotationMaxPortaEsq = rotationMaxPortaEsq;
      return self;
end;
 
function SetDoorLeftRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMaxPortaEsq = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorLeftRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMaxPortaEsq);
end;
 
function SetDoorLeftRotationEvent:run(connection)
      self.object:setRotationMaxPortaEsq(self.rotationMaxPortaEsq, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorLeftRotationEvent:new(self.object, self.rotationMaxPortaEsq), nil, connection, self.object);
      end;
end;