SetDoorRightRotationEvent = {};
SetDoorRightRotationEvent_mt = Class(SetDoorRightRotationEvent, Event);
  
InitEventClass(SetDoorRightRotationEvent, "SetDoorRightRotationEvent");
  
function SetDoorRightRotationEvent:emptyNew()
      local self = Event:new(SetDoorRightRotationEvent_mt);
      self.className="SetDoorRightRotationEvent";
      return self;
 end;

function SetDoorRightRotationEvent:new(object, rotationMaxPortaDta)
      local self = SetDoorRightRotationEvent:emptyNew()
      self.object = object;
      self.rotationMaxPortaDta = rotationMaxPortaDta;
      return self;
end;
 
function SetDoorRightRotationEvent:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.rotationMaxPortaDta = streamReadBool(streamId);
      self.object = networkGetObject(id);
      self:run(connection);
end;
  
function SetDoorRightRotationEvent:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
      streamWriteBool(streamId, self.rotationMaxPortaDta);
end;
 
function SetDoorRightRotationEvent:run(connection)
      self.object:setRotationMaxPortaDta(self.rotationMaxPortaDta, true);
      if not connection:getIsServer() then
          g_server:broadcastEvent(SetDoorRightRotationEvent:new(self.object, self.rotationMaxPortaDta), nil, connection, self.object);
      end;
end;